// Generated by CoffeeScript 1.7.1
(function() {
  var app, e, extensionInfoMap, fs, getExtensionInfoFromPath, getHostForPath, getPathForHost, hostPathMap, hostPathMapNextKey, loadedExtensions, loadedExtensionsPath, path, srcDirectory, url, _i, _len;

  app = require('app');

  fs = require('fs');

  path = require('path');

  url = require('url');

  hostPathMap = {};

  hostPathMapNextKey = 0;

  getHostForPath = function(path) {
    var key;
    key = "extension-" + (++hostPathMapNextKey);
    hostPathMap[key] = path;
    return key;
  };

  getPathForHost = function(host) {
    return hostPathMap[host];
  };

  extensionInfoMap = {};

  getExtensionInfoFromPath = function(srcDirectory) {
    var manifest, page;
    manifest = JSON.parse(fs.readFileSync(path.join(srcDirectory, 'manifest.json')));
    if (extensionInfoMap[manifest.name] == null) {
      page = url.format({
        protocol: 'chrome-extension',
        slashes: true,
        hostname: getHostForPath(srcDirectory),
        pathname: manifest.devtools_page
      });
      extensionInfoMap[manifest.name] = {
        startPage: page,
        name: manifest.name,
        srcDirectory: srcDirectory
      };
    }
    return extensionInfoMap[manifest.name];
  };

  loadedExtensionsPath = path.join(app.getDataPath(), 'DevTools Extensions');

  try {
    loadedExtensions = JSON.parse(fs.readFileSync(loadedExtensionsPath));
    if (!Array.isArray(loadedExtensions)) {
      loadedExtensions = [];
    }
    for (_i = 0, _len = loadedExtensions.length; _i < _len; _i++) {
      srcDirectory = loadedExtensions[_i];
      getExtensionInfoFromPath(srcDirectory);
    }
  } catch (_error) {
    e = _error;
  }

  app.on('will-quit', function() {
    try {
      loadedExtensions = Object.keys(extensionInfoMap).map(function(key) {
        return extensionInfoMap[key].srcDirectory;
      });
      try {
        fs.mkdirSync(path.dirname(loadedExtensionsPath));
      } catch (_error) {
        e = _error;
      }
      return fs.writeFileSync(loadedExtensionsPath, JSON.stringify(loadedExtensions));
    } catch (_error) {
      e = _error;
    }
  });

  app.once('ready', function() {
    var BrowserWindow, init, protocol;
    protocol = require('protocol');
    BrowserWindow = require('browser-window');
    protocol.registerProtocol('chrome-extension', function(request) {
      var directory, parsed;
      parsed = url.parse(request.url);
      if (!(parsed.hostname && (parsed.path != null))) {
        return;
      }
      if (!/extension-\d+/.test(parsed.hostname)) {
        return;
      }
      directory = getPathForHost(parsed.hostname);
      if (directory == null) {
        return;
      }
      return new protocol.RequestFileJob(path.join(directory, parsed.path));
    });
    BrowserWindow.prototype._loadDevToolsExtensions = function(extensionInfoArray) {
      var _ref;
      return (_ref = this.devToolsWebContents) != null ? _ref.executeJavaScript("WebInspector.addExtensions(" + (JSON.stringify(extensionInfoArray)) + ");") : void 0;
    };
    BrowserWindow.addDevToolsExtension = function(srcDirectory) {
      var extensionInfo, window, _j, _len1, _ref;
      extensionInfo = getExtensionInfoFromPath(srcDirectory);
      _ref = BrowserWindow.getAllWindows();
      for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {
        window = _ref[_j];
        window._loadDevToolsExtensions([extensionInfo]);
      }
      return extensionInfo.name;
    };
    BrowserWindow.removeDevToolsExtension = function(name) {
      return delete extensionInfoMap[name];
    };
    init = BrowserWindow.prototype._init;
    return BrowserWindow.prototype._init = function() {
      init.call(this);
      return this.on('devtools-opened', function() {
        return this._loadDevToolsExtensions(Object.keys(extensionInfoMap).map(function(key) {
          return extensionInfoMap[key];
        }));
      });
    };
  });

}).call(this);
